﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class ReportTimeToCompleteEvalGreater30Days : System.Web.UI.Page
{

    #region Variable Declarations

    //TBIExceptionHandler _tbiexception = new TBIExceptionHandler();
    List<ReportParameter> _reportParameters = new List<ReportParameter>();
    string _reportName = "ReportTimeToCompleteEvalGreater30DaysNational";
    private UserAccountManager _currentUser;

    #endregion

    #region Protected Variables

    protected void Page_Load(object sender, EventArgs e)
    {
        if (AccessAllowed())
        {
            SetReportParameters();

            if (!IsPostBack)
            {
                SetDropDownListLevel();
                EnableDropDownListsVisnAndStation(false, false);
                CheckBoxListStatus.SelectedIndex = 3;
            }
            EnableButtonRunReport();
            DisableReportViewer();
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }
    
    void Page_PreRender(object sender, EventArgs e)
    {
        EnableButtonRunReport();
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        try
        {
            string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
            ReportParameter reportParam = new ReportParameter("UserId", userId);
            _reportParameters.Add(reportParam);

            if (ReportStatusIsSet())
            {
                if (DropDownListReportLevel.SelectedValue == "National")
                {
                    ReportViewerNational.Reset();

                    ReportParameter reportParamFromDate = new ReportParameter("FromDate", (!string.IsNullOrEmpty(DateFrom.DateValue) ? DateFrom.DateValue : null));
                    _reportParameters.Add(reportParamFromDate);
                    ReportParameter reportParamToDate = new ReportParameter("ToDate", (!string.IsNullOrEmpty(DateTo.DateValue) ? DateTo.DateValue : null));
                    _reportParameters.Add(reportParamToDate);
                    ReportParameter reportParamReferralStatusString = new ReportParameter("ReferralStatusString", DropDownListStatus.SelectedValue);
                    _reportParameters.Add(reportParamReferralStatusString);
                    ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser.FullName);
                    _reportParameters.Add(reportParamUsername);

                    ReportViewerNational.ServerReport.ReportPath = _reportName;

                    ReportViewerNational.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
                    if (ReportViewerNational.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                    {
                        ReportViewerNational.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewerNational.ServerReport.ReportPath;
                        //ReportViewerNational.ServerReport.ReportPath = config.BaseReportPath + ReportViewerNational.ServerReport.ReportPath;
                    }
                    ReportViewerNational.ServerReport.SetParameters(_reportParameters.ToArray());

                    ReportViewerNational.ProcessingMode = ProcessingMode.Remote;
                    ReportViewerNational.ServerReport.Refresh();
                    ReportViewerNational.Visible = true;
                }
                else if (DropDownListReportLevel.SelectedValue == "VISN")
                {
                    if (DropDownListVisnID.SelectedIndex > 0)
                    {
                        ReportViewerVisn.Reset();

                        ReportParameter reportParamFromDate = new ReportParameter("FromDate", (!string.IsNullOrEmpty(DateFrom.DateValue) ? DateFrom.DateValue : null));
                        _reportParameters.Add(reportParamFromDate);
                        ReportParameter reportParamToDate = new ReportParameter("ToDate", (!string.IsNullOrEmpty(DateTo.DateValue) ? DateTo.DateValue : null));
                        _reportParameters.Add(reportParamToDate);
                        ReportParameter reportParamReferralStatusString = new ReportParameter("ReferralStatusString", DropDownListStatus.SelectedValue);
                        _reportParameters.Add(reportParamReferralStatusString);
                        ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser.FullName);
                        _reportParameters.Add(reportParamUsername);

                        ReportParameter reportParamVisnId = new ReportParameter("VisnId", (DropDownListVisnID.SelectedValue));
                        _reportParameters.Add(reportParamVisnId);
                        _reportName = "ReportTimeToCompleteEvalGreater30DaysVisn";
                        ReportViewerVisn.ServerReport.ReportPath = _reportName;
                        ReportViewerVisn.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
                        if (ReportViewerVisn.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                        {
                            ReportViewerVisn.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewerVisn.ServerReport.ReportPath;
                            //ReportViewerVisn.ServerReport.ReportPath = config.BaseReportPath + ReportViewerVisn.ServerReport.ReportPath;
                        }
                        ReportViewerVisn.ServerReport.SetParameters(_reportParameters.ToArray());
                        ReportViewerVisn.ProcessingMode = ProcessingMode.Remote;
                        ReportViewerVisn.ServerReport.Refresh();
                        ReportViewerVisn.Visible = true;
                    }
                }
                else
                {
                    if (DropDownListFacility.SelectedIndex > 0)
                    {
                        ReportViewerStation.Reset();
                        ReportParameter reportParamFromDate = new ReportParameter("FromDate", (!string.IsNullOrEmpty(DateFrom.DateValue) ? DateFrom.DateValue : null));
                        _reportParameters.Add(reportParamFromDate);
                        ReportParameter reportParamToDate = new ReportParameter("ToDate", (!string.IsNullOrEmpty(DateTo.DateValue) ? DateTo.DateValue : null));
                        _reportParameters.Add(reportParamToDate);
                        ReportParameter reportParamReferralStatusString = new ReportParameter("ReferralStatusString", DropDownListStatus.SelectedValue);
                        _reportParameters.Add(reportParamReferralStatusString);
                        ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser.FullName);
                        _reportParameters.Add(reportParamUsername);

                        ReportParameter reportParamVisnId = new ReportParameter("FacilityId", (DropDownListFacility.SelectedValue));
                        _reportParameters.Add(reportParamVisnId);
                        _reportName = "ReportTimeToCompleteEvalGreater30DaysStation";
                        ReportViewerStation.ServerReport.ReportPath = _reportName;
                        ReportViewerStation.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
                        if (ReportViewerStation.ServerReport.ReportPath.IndexOf(Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)                        
                        {
                            ReportViewerStation.ServerReport.ReportPath = Helpers.GetConfigEntry("BaseReportPath") + ReportViewerStation.ServerReport.ReportPath;
                            //ReportViewerStation.ServerReport.ReportPath = config.BaseReportPath + ReportViewerStation.ServerReport.ReportPath;
                        }
                        ReportViewerStation.ServerReport.SetParameters(_reportParameters.ToArray());
                        ReportViewerStation.ProcessingMode = ProcessingMode.Remote;
                        ReportViewerStation.ServerReport.Refresh();
                        ReportViewerStation.Visible = true;
                    }
                }
            }
            else
            {
                Response.Redirect("ErrorPage.aspx?id=101");
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100015", "Get() ReportData");
        }
    }

    protected void DropDownListReportLevel_SelectedIndexChanged(object sender, EventArgs e)
    {
        try
        {
            if (DropDownListReportLevel.SelectedValue == "Select One")
            {
                ButtonRunReport.Enabled = false;
                EnableDropDownListsVisnAndStation(false, false);
            }
            else if (DropDownListReportLevel.SelectedValue == "National")
            {
                ButtonRunReport.Enabled = true;
                EnableDropDownListsVisnAndStation(false, false);
            }
            else
            {
                EnableDropDownListsVisnAndStation(true, false);
                SetDropDownListVisnId();
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100015", "Dropdown Report Level Selected");
        }
    }

    protected void DropDownListVisnID_SelectedIndexChanged(object sender, EventArgs e)
    {
        try
        {
            if (DropDownListReportLevel.SelectedValue == "VISN")
            {
                EnableDropDownListsVisnAndStation(true, false);
            }
            else if (DropDownListReportLevel.SelectedValue == "Station")
            {
                SetDropDownListFacility();
                EnableDropDownListsVisnAndStation(true, true);
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100015", "Dropdown Visn Selected");
        }
    }

    protected void ObjectDataSourcePermittedStations_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        try
        {
            e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100015", "Dropdown Stations Selecting");
        }
    }

    protected void ObjectDataSourcePermittedVISNs_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        try
        {
            e.InputParameters["userName"] = HttpContext.Current.User.Identity.Name.ToLower();
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100015", "Dropdown Visn Selecting");
        }
    }

    private void SetDropDownListVisnId()
    {
        try
        {
            if (!_currentUser.IsInRole(16))
            {
                if (DropDownListReportLevel.SelectedValue == "VISN")
                {
                    DropDownListVisnID.DataSource = ObjectDataSourceDirectlyPermittedVISNs;
                }
                else if (DropDownListReportLevel.SelectedValue == "Station")
                {
                    DropDownListVisnID.DataSource = ObjectDataSourcePermittedStationVISNs;
                }
                DropDownListVisnID.DataBind();
                DropDownListVisnID.Items.Insert(0, new ListItem("Select One", "000"));
            }
            DropDownListVisnID.SelectedIndex = 0;
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100015", "SetDropDownListVisnId()");
        }
    }

    private void SetDropDownListFacility()
    {
        try
        {
            if (DropDownListVisnID.SelectedIndex != 0)
            {
                if (_currentUser.IsInRole(16))
                {
                    DropDownListFacility.DataSource = ObjectDataSource3;
                }
                else
                {
                    DropDownListFacility.DataSource = ObjectDataSourcePermittedStations;
                }
                DropDownListFacility.DataBind();
                DropDownListFacility.Items.Insert(0, new ListItem("Select One", "000"));
                DropDownListFacility.SelectedIndex = 0;
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100015", "Dropdown Facility Binding");
        }
    }

    private bool ReportStatusIsSet()
    {
        try
        {
            if (CheckBoxListStatus.Items[0].Selected & !CheckBoxListStatus.Items[1].Selected & !CheckBoxListStatus.Items[2].Selected)
            {
                DropDownListStatus.SelectedValue = "1";
            }
            else if (!CheckBoxListStatus.Items[0].Selected & CheckBoxListStatus.Items[1].Selected & !CheckBoxListStatus.Items[2].Selected)
            {
                DropDownListStatus.SelectedValue = "2";
            }
            else if (!CheckBoxListStatus.Items[0].Selected & !CheckBoxListStatus.Items[1].Selected & CheckBoxListStatus.Items[2].Selected)
            {
                DropDownListStatus.SelectedValue = "3";
            }
            else if (CheckBoxListStatus.Items[0].Selected & CheckBoxListStatus.Items[1].Selected & !CheckBoxListStatus.Items[2].Selected)
            {
                DropDownListStatus.SelectedValue = "12";
            }
            else if (!CheckBoxListStatus.Items[0].Selected & CheckBoxListStatus.Items[1].Selected & CheckBoxListStatus.Items[2].Selected)
            {
                DropDownListStatus.SelectedValue = "23";
            }
            else if (CheckBoxListStatus.Items[0].Selected & CheckBoxListStatus.Items[1].Selected & CheckBoxListStatus.Items[2].Selected)
            {
                DropDownListStatus.SelectedValue = "123";
            }
            else
            {
                DropDownListStatus.SelectedValue = "0";
                return false;
            }
            return true;
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100015", "ReportStatusIsSet()");
            return false;
        }
    }

    #endregion

    #region Private Methods

    private bool AccessAllowed()
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;
        return (_currentUser.IsInRole(16) || _currentUser.IsInRole(17) || _currentUser.IsInRole(18));
    }

    private void SetReportParameters()
    {
        //string userId = System.Security.Principal.WindowsIdentity.GetCurrent().Name;
        //ReportParameter reportParam = new ReportParameter("UserId", userId);
        //_reportParameters.Add(reportParam);
        //ReportViewerNational.LocalReport.SetParameters(_reportParameters.ToArray());
        //ReportViewerVisn.LocalReport.SetParameters(_reportParameters.ToArray());
        //ReportViewerStation.LocalReport.SetParameters(_reportParameters.ToArray());
    }

    private void SetDropDownListLevel()
    {
        try
        {
            _currentUser = (UserAccountManager)HttpContext.Current.User;
            AddListItem("Select One");

            if (_currentUser.IsInRole(16))
            {
                AddListItem("National");
                AddListItem("VISN");
                AddListItem("Station");
                DropDownListReportLevel.Items[0].Selected = true;
            }

            if (_currentUser.IsInRole(17))
            {
                AddListItem("VISN");
                AddListItem("Station");
                DropDownListReportLevel.Items[0].Selected = true;
            }

            if (_currentUser.IsInRole(18))
            {
                AddListItem("Station");
                DropDownListReportLevel.Items[0].Selected = true;
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100015", "SetDropDownListLevel()");
        }
    }

    private void AddListItem(string itemValue)
    {
        try
        {
            var listItem = new ListItem(itemValue);
            if (!DropDownListReportLevel.Items.Contains(listItem))
            {
                DropDownListReportLevel.Items.Add(listItem);
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100015", "AddListItem()");
        }
    }

    private void EnableDropDownListsVisnAndStation(bool dropDownListVisnIdIsVisible, bool dropDownListFacilityIsVisible)
    {
        DropDownListVisnID.Visible = dropDownListVisnIdIsVisible;
        DivVISN.Visible = dropDownListVisnIdIsVisible;
        DropDownListFacility.Visible = dropDownListFacilityIsVisible;
        DivStation.Visible = dropDownListFacilityIsVisible;
    }

    private void EnableButtonRunReport()
    {
        try
        {
            if (CheckBoxListStatus.SelectedIndex < 0 ||
                 DropDownListReportLevel.SelectedValue == "Select One" ||
                 (DropDownListReportLevel.SelectedValue == "VISN" && DropDownListVisnID.SelectedIndex < 1) ||
                 (DropDownListReportLevel.SelectedValue == "Station" &&
                  (DropDownListVisnID.SelectedIndex < 1
                   || DropDownListFacility.SelectedIndex < 1))
                )
            {
                ButtonRunReport.Enabled = false;
            }
            else
            {
                ButtonRunReport.Enabled = true;
            }
        }
        catch (Exception _ex)
        {
            //_tbiexception.HandleTBIException(_ex, _reportName, "100015", "EnableButtonRunReport()");
        }
    }

    private void DisableReportViewer()
    {
        ReportViewerNational.Visible = false;
        ReportViewerVisn.Visible = false;
        ReportViewerStation.Visible = false;
    }

    #endregion

}
